package gov.va.genisis2.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.List;

import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.dao.IStudyApprovalDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.util.Helper;

/**
 * The Class StudyApprovalDaoTest.
 *
 * @author Getaneh Kassahun
 * 
 *         The Class StudyApprovalDaoTest.
 * 
 *         Description: In this StudyApprovalDaoTest Class which extends the
 *         abstract class, AbstractMockMvcTests, junit tests are defined.
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class StudyApprovalDaoTest extends AbstractMockMvcTests {

	/** The LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(StudyApprovalDaoTest.class);

	@Autowired
	private IStudyApprovalDao studyApprovalDao;

	/**
	 * Test create study approval null.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void test1CreateStudyApproval_Null() throws GenisisDAOException {

		LOGGER.info("**********Junit Test Create Study Approval Null**********");
		Assert.assertEquals(0, studyApprovalDao.createStudyApproval(null));

	}

	/**
	 * Test create study approval not null.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void test2CreateStudyApproval_notNull() throws GenisisDAOException {

		LOGGER.info("**********JunitTest Create Study Approval Not Null**********");
		Assert.assertTrue(studyApprovalDao.createStudyApproval(Helper.getNewStudyApproval()) > 175);

	}

	/**
	 * Test get study approval by id.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void test3GetStudyApprovalById() throws GenisisDAOException {

		LOGGER.info("**********Junit Test Get Study Approval By Id**********");
		Assert.assertNotNull((StudyApproval) studyApprovalDao.getStudyApprovalsByID(176));

	}

	/**
	 * Test get study approval by UID.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void test4GetStudyApprovalByUID() throws GenisisDAOException {

		LOGGER.info("**********Junit Test Study Approval By UID**********");
		List<StudyApproval> listOfstudyApproval = studyApprovalDao.getStudyApprovalsByUID("researcher1");
		Assert.assertNotNull(listOfstudyApproval);
	}

	/**
	 * Test get study approval.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void test5GetStudyApproval() throws GenisisDAOException {

		LOGGER.info("**********Junit Test Study Approval By UID**********");
		List<StudyApproval> listOfstudyApproval = studyApprovalDao.getStudyApprovals();
		Assert.assertNotNull(listOfstudyApproval);
	}

	/**
	 * Test update study approval.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void test6UpdateStudyApproval() throws GenisisDAOException {

		LOGGER.info("**********Junit Test Update Study Approval**********");
		StudyApproval studyApproval = studyApprovalDao.getStudyApprovalsByID(176);
		assertNotNull(studyApproval);
		assertEquals(176, studyApproval.getId());
		studyApproval.setTitle("Test update study approval");
		//Assert.assertEquals(176, studyApprovalDao.updateStudyApproval(studyApproval));
	}
	
	/**
	 * Test update study approval.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void test7UpdateStudyApproval() throws GenisisDAOException {

		LOGGER.info("**********Junit Test Update Study Approval with Id 0**********");
		StudyApproval studyApproval = studyApprovalDao.getStudyApprovalsByID(178);
		assertNotNull(studyApproval);
		assertEquals(178, studyApproval.getId());
		studyApproval.setId(0);
		Assert.assertEquals(0, studyApprovalDao.updateStudyApproval(studyApproval));
	}

}
